<?php
require 'headers.php';
require_once 'stripe-php/init.php'; // Stripe SDK


use Stripe\Stripe;
use Stripe\Checkout\Session as StripeSession;

Stripe::setApiKey('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');

if (!isset($_SESSION['unique_id']) || !isset($_SESSION['pay_ref'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit;
}

$unique_id = $_SESSION['unique_id'];
$payment_ref = $_SESSION['pay_ref'];
$transact_id = $_GET['transact_id'] ?? null;

if (!$transact_id) {
    echo json_encode(['success' => false, 'message' => 'Transaction ID missing']);
    exit;
}

try {
    $session = StripeSession::retrieve($transact_id);

    if (!$session || $session->payment_status !== 'paid') {
        echo json_encode(['success' => false, 'message' => 'Payment not verified']);
        exit;
    }
    
     // 👈 NEW LINE: Get amount total from session (Stripe returns in cents)
    $amount_paid = $session->amount_total / 100; // e.g. 1299 = 12.99

    $order_date = new DateTime();

    function addBusinessDays($date, $days) {
        $count = 0;
        while ($count < $days) {
            $date->modify('+1 day');
            if ($date->format('N') < 6) {
                $count++;
            }
        }
        return $date->format('Y-m-d');
    }

    $pre_delivery = addBusinessDays(clone $order_date, 5);
    $delivery_date = addBusinessDays(clone $order_date, 10);
    $order_date = $order_date->format('Y-m-d');
 

           $update_stmt = $pdo->prepare("
                UPDATE ordered 
                SET tracking = 'paid', order_date = ?, pre_delivery = ?, delivery_date = ?, price = ? 
                WHERE payment_ref = ?
            ");
            $update_stmt->execute([$order_date, $pre_delivery, $delivery_date, $amount_paid, $payment_ref]);
        

    if ($update_stmt->rowCount() > 0) {
        // ✅ Fetch customer email
        $email_stmt = $pdo->prepare("SELECT email, name FROM users WHERE unique_id = ?");
        $email_stmt->execute([$unique_id]);
        $user = $email_stmt->fetch(PDO::FETCH_ASSOC);
        $user_email = $user['email'] ?? '';
        $user_name = $user['name'] ?? 'Customer';

        // ✅ Send confirmation email to customer
        $customer_subject = 'Order Confirmed - Witty Nail';
        $customer_body = "
            <p>Dear $user_name,</p>
            <p>Thank you for your purchase. Your order has been successfully placed and is now being processed.</p>
            <p><strong>Order Reference:</strong> $payment_ref<br>
               <strong>Estimated Pre-Delivery:</strong> $pre_delivery<br>
               <strong>Estimated Delivery:</strong> $delivery_date</p>
            <p>You will receive updates about your order via email.</p>
            <p>Best regards,<br><strong>Witty Nail</strong></p>
        ";

        EmailService::sendEmail("$user_email", "$customer_subject", "$customer_body");

        // ✅ Notify admin
        $admin_subject = 'New Order Received - Witty Nail';
        $admin_body = "
            <p>Hello Admin,</p>
            <p>A new order has been placed by <strong>$user_name</strong> (Email: $user_email).</p>
            <p><strong>Order Reference:</strong> $payment_ref<br>
               <strong>Stripe Transaction ID:</strong> $transact_id</p>
            <p>Please check the admin panel to process the order.</p>
        ";

        EmailService::sendEmail("wittybeauty2025@gmail.com", "$admin_subject", "$admin_body");

        echo json_encode(['success' => true, 'message' => 'Payment verified, order updated and emails sent']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to update order']);
    }

} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}
?>
