<?php
  ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
require 'headers2.php';

// Ensure request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Decode JSON input
   $input = file_get_contents('php://input');
   error_log("Raw Input: $input");

if (!$input) {
    echo json_encode(['success' => false, 'message' => 'No data received']);
    exit;
}

$data = json_decode($input, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode([
        'success' => false,
        'message' => 'Invalid JSON input: ' . json_last_error_msg()
    ]);
    exit;
}

    // Extract inputs
    $email = trim($data['email'] ?? '');
    $username = trim($data['username'] ?? '');
    $password = trim($data['password'] ?? '');
    $confirmPassword = trim($data['confirmPassword'] ?? '');
    $rand = rand(10000, 1000000);

    // Validate inputs
    if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        echo json_encode(['success' => false, 'message' => 'Invalid email address']);
        exit;
    }

    if (empty($username)) {
        echo json_encode(['success' => false, 'message' => 'Username is required']);
        exit;
    }

    if (strlen($password) < 6) {
        echo json_encode(['success' => false, 'message' => 'Password must be at least 6 characters']);
        exit;
    }

    if ($password !== $confirmPassword) {
        echo json_encode(['success' => false, 'message' => 'Passwords do not match']);
        exit;
    }

    // Hash the password
    $hashedPassword = md5($password);

    // Insert user into the database
    try {
       $pdo = $GLOBALS['pdo']; // ✅ Access global version
        $stmt = $pdo->prepare("INSERT INTO users (email, username, password, unique_id) VALUES (:email, :username, :password, :unique_id)");
        $stmt->execute([
            'email' => $email,
            'username' => $username,
            'password' => $hashedPassword,
            'unique_id' => $rand,
        ]);

        echo json_encode(['success' => true, 'message' => 'User registered successfully']);
        
        //email nofication.
             $subject = ' Welcome to Witty Nail – Your Beauty, Our Priority!';

            $body = "<p>Hello,</p>
            
                     <p>Welcome to <strong>Witty Nail</strong>! 💅 We're excited to have you join our community of nail lovers and beauty enthusiasts.</p>
            
                     <p>✨ **Explore Our Nail Products & Shop Now!**<br>
                     From stunning nail polish collections to premium nail care kits, we have everything you need to keep your nails looking fabulous.</p>
            
                     <p>🎁 **Exclusive Offers Coming Soon!**<br>
                     Get ready for special discounts, exclusive deals, and early access to our best-selling products.</p>
            
                     <p>🚚 **We Deliver Anywhere in the USA!**<br>
                     Enjoy fast and reliable shipping straight to your doorstep.</p>
            
                     <p>👉 **Start Shopping Now:** <a href='https://www.wittynailtip.com/shop'>Visit Our Store</a></p>
            
                     <p>Thank you for choosing Witty Nail. We can't wait to be part of your beauty journey! 💖</p>
            
                     <p>Best Regards, <br>
                     <strong>Witty Nail Support Team</strong></p>";
                     
                     $result = EmailService::sendEmail("$email", "$subject", "$body");
            echo $result;

    } catch (PDOException $e) {
        if ($e->getCode() === '23000') { // Duplicate entry
            echo json_encode(['success' => false, 'message' => 'Email already exists']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Error registering user']);
        }
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}
