<?php
require 'headers.php';



try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed: ' . $e->getMessage()]);
    exit;
}



// Get user ID from session
$user_id = $_SESSION['unique_id'];
 

// Fetch user profile data
$query = "SELECT username, email, name, number, billing FROM users WHERE unique_id = :user_id";
$stmt = $pdo->prepare($query);
$stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);

try {
    $stmt->execute();
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        // Check for empty fields and prepare a response
        $response = [
            "status" => "success",
            "data" => [
                "username" => $user['username'] ?: "Not provided. Please edit your profile.",
                "email" => $user['email'] ?: "Not provided. Please edit your profile.",
                "full_name" => $user['name'] ?: "Not provided. Please edit your profile.",
                "phone_number" => $user['number'] ?: "Not provided. Please edit your profile.",
                "billing_address" => $user['billing'] ?: "Not provided. Please edit your profile."
            ]
        ];
        echo json_encode($response);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "User not found."
        ]);
    }
} catch (Exception $e) {
    echo json_encode([
        "status" => "error",
        "message" => "Failed to fetch user data: " . $e->getMessage()
    ]);
}
?>
