<?php
require 'headers2.php';

// Initialize the Stripe client
$stripe = new \Stripe\StripeClient('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');


// Database connection
$conn = new mysqli('localhost', 'lxiernde_witty', 'Wittynail2024.', 'lxiernde_witty');

if ($conn->connect_error) {
    die(json_encode(['status' => 'error', 'message' => 'Database connection failed.']));
}

try {
    // Fetch all products from Stripe
    $products = $stripe->products->all(['limit' => 100, 'active' => true]);

    // Prepare an array to hold product data with prices
    $productData = [];

    foreach ($products->data as $product) {
        // Fetch associated prices for each product
        $prices = $stripe->prices->all(['product' => $product->id]);

        // Query database for colors using product_id
        $stmt = $conn->prepare("SELECT color1, color2, color3, color4, color5, color6, color7, color8, color9, color10 FROM product WHERE product_id = ?");
        $stmt->bind_param("s", $product->id);
        $stmt->execute();
        $result = $stmt->get_result();
        $colorRow = $result->fetch_assoc();
        $stmt->close();

        // Only keep colors that have a value
        $colors = [];
        if ($colorRow) {
            foreach ($colorRow as $key => $color) {
                if (!empty($color)) {
                    $colors[$key] = $color;
                }
            }
        }

        // Add product, price details, and colors to the array
        $productData[] = [
            'id' => $product->id,
            'name' => $product->name,
            'description' => $product->description,
            'images' => $product->images,
            'prices' => array_map(function ($price) {
                return [
                    'id' => $price->id,
                    'unit_amount' => $price->unit_amount / 100, // Convert to dollars
                    'currency' => strtoupper($price->currency)
                ];
            }, $prices->data),
            'colors' => $colors // Add colors
        ];
    }

    // Close database connection
    $conn->close();

    // Send JSON response
    echo json_encode([
        'status' => 'success',
        'data' => $productData
    ]);
} catch (\Stripe\Exception\ApiErrorException $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>
