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<?php
require 'headers2.php';

$data = json_decode(file_get_contents('php://input'), true);
$product_id = $data['product_id'] ?? null;

if (!$product_id) {
    echo json_encode(['success' => false, 'message' => 'Product ID is required']);
    exit;
}

$stripe = new \Stripe\StripeClient('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');

$conn = new mysqli('localhost', 'lxiernde_witty', 'Wittynail2024.', 'lxiernde_witty');

if ($conn->connect_error) {
    die(json_encode(['success' => false, 'message' => 'Database connection failed']));
}

try {
    $product = $stripe->products->retrieve($product_id);
    $prices = $stripe->prices->all(['product' => $product_id]);
    $price = $prices->data[0] ?? null;

    // Pull category and all potential fields
    $stmt = $conn->prepare("
        SELECT category, quantity, created_at,
               xs, small, med, large,
               pimg2, pimg3, pimg4, pimg5,
               color1, img1, color2, img2, color3, img3, color4, img4, color5, img5,
               color6, img6, color7, img7, color8, img8, color9, img9, color10, img10
        FROM product WHERE product_id = ?
    ");
    $stmt->bind_param("s", $product_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $productRow = $result->fetch_assoc();
    $stmt->close();
    $conn->close();

    // Extract extra images
    $extraImages = [];
    for ($i = 2; $i <= 5; $i++) {
        $imgKey = "pimg$i";
        if (!empty($productRow[$imgKey])) {
            $extraImages[] = $productRow[$imgKey];
        }
    }

    $response = [
        'product_id' => $product->id,
        'name' => $product->name,
        'description' => $product->description,
        'images' => $product->images,
        'pimg_extra' => $extraImages,
        'metadata' => $product->metadata,
        'price' => $price ? [
            'id' => $price->id,
            'unit_amount' => $price->unit_amount / 100,
            'currency' => strtoupper($price->currency),
        ] : null,
        'created_at' => $productRow['created_at'] ?? null,
        'category' => $productRow['category'] ?? null
    ];

    // 🔀 Conditional logic based on category
    if (strtolower($productRow['category']) === 'accessory') {
        // Accessory logic – include `quantity` only
        $response['total_quantity'] = (int) $productRow['quantity'];
        
    }elseif(strtolower($productRow['category']) === 'machine'){
          // machine product logic – color/image mapping
          
        $colorImages = [];
        for ($i = 1; $i <= 10; $i++) {
            $color = $productRow["color$i"] ?? null;
            $img = $productRow["img$i"] ?? null;
            if (!empty($color)) {
                $colorImages["Color $i"] = $color;
            }
            if (!empty($img)) {
                $colorImages["Image $i"] = $img;
            }
        }
        $response['total_quantity'] = (int) $productRow['quantity'];
        $response['color_image_pairs'] = $colorImages;
        
    } else {
        // Standard product logic – sizes and color/image mapping
        $sizes = [
            'xs' => (int)$productRow['xs'],
            'small' => (int)$productRow['small'],
            'med' => (int)$productRow['med'],
            'large' => (int)$productRow['large']
        ];
        $total_quantity = array_sum($sizes);

        $colorImages = [];
        for ($i = 1; $i <= 10; $i++) {
            $color = $productRow["color$i"] ?? null;
            $img = $productRow["img$i"] ?? null;
            if (!empty($color)) {
                $colorImages["Color $i"] = $color;
            }
            if (!empty($img)) {
                $colorImages["Image $i"] = $img;
            }
        }

        $response['sizes'] = $sizes;
        $response['total_quantity'] = $total_quantity;
        $response['color_image_pairs'] = $colorImages;
    }

    echo json_encode(['success' => true, 'data' => $response]);

} catch (\Stripe\Exception\ApiErrorException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error fetching product details',
        'error' => $e->getMessage()
    ]);
}
?>
