<?php
require 'headers.php';
require_once 'stripe-php/init.php'; // Ensure Stripe SDK is installed


$unique_id = $_SESSION['unique_id'];

// Retrieve and validate POST data
$data = json_decode(file_get_contents('php://input'), true);
$order_id = $data['order_id'] ?? null;

if (!$order_id) {
    echo json_encode(['success' => false, 'message' => 'Order ID is required']);
    exit;
}

// Retrieve the specific order for the user where tracking = 'Paid'
$stmt = $pdo->prepare("SELECT * FROM ordered WHERE unique_id = :unique_id AND id = :order_id AND tracking = 'paid' LIMIT 10");
$stmt->execute(['unique_id' => $unique_id, 'order_id' => $order_id]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$order) {
    echo json_encode(['success' => false, 'message' => 'No paid order found']);
    exit;
}

$product_id = $order['product_id']; // Get product_id from the order

// Initialize the Stripe client
$stripe = new \Stripe\StripeClient('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');

try {
    // Fetch product details from Stripe
    $product = $stripe->products->retrieve($product_id);
    $prices = $stripe->prices->all(['product' => $product_id]);
    $price = $prices->data[0] ?? null;

    if (!$price) {
        echo json_encode(['success' => false, 'message' => 'Price not found for product']);
        exit;
    }

    $unitAmount = $price->unit_amount / 100; // Convert to dollars
    $finalPrice = $unitAmount * $order['quantity']; // Total price based on quantity

    $orderDetails = [
        'order_id' => $order['id'],
        'product_id' => $product->id,
        'name' => $product->name,
        'description' => $product->description,
        'images' => $product->images,
        'initial_price' => [
            'id' => $price->id,
            'unit_amount' => $unitAmount,
            'currency' => strtoupper($price->currency)
        ],
        'quantity' => $order['quantity'],
        'final_price' => $finalPrice,
        'color' => $order['color'],
        'size' => $order['size'],
        'tracking' => $order['tracking'],
        'status' => $order['status'],
        'payment_ref' => $order['payment_ref'],
        'order_date' => $order['order_date'],
        'pre_delivery' => $order['pre_delivery'],
        'delivery_date' => $order['delivery_date'],
        'created_at' => $order['created_at']
    ];

    // Return response
    echo json_encode([
        'success' => true,
        'order' => $orderDetails
    ]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error retrieving product data: ' . $e->getMessage()]);
    exit;
}
?>
