<?php
$isLocalhost = strpos($_SERVER['HTTP_HOST'], 'localhost') !== false;

// Optional (sometimes required)
ini_set('session.cookie_secure', $isLocalhost ? '0' : '1');
ini_set('session.cookie_samesite', $isLocalhost ? 'Lax' : 'None');

session_set_cookie_params([
    'lifetime' => 2592000,
    'path' => '/',
    'domain' => $isLocalhost ? '' : 'wittynailtip.com',
    'secure' => !$isLocalhost,
    'httponly' => true,
    'samesite' => $isLocalhost ? 'Lax' : 'None'
]);
session_start();
require 'mail.php';

$allowed_origins = [
    "http://localhost:3000",
    "https://nail-salon-gamma.vercel.app"
];

if (isset($_SERVER['HTTP_ORIGIN'])) {
    if (in_array($_SERVER['HTTP_ORIGIN'], $allowed_origins)) {
        header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
    }
} else {
    // If there's no origin, allow all (use carefully)
    header("Access-Control-Allow-Origin: *");
}

// CORS headers
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

// Handle preflight request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}


// Database connection
$host = 'localhost';
$dbname = 'lxiernde_witty';
$username = 'lxiernde_witty';
$pass = 'Wittynail2024.';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed']);
    exit;
}

// Handle POST request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
     // Decode JSON input
   $input = file_get_contents('php://input');
   error_log("Raw Input: $input");

if (!$input) {
    echo json_encode(['success' => false, 'message' => 'No data received']);
    exit;
}

$data = json_decode($input, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode([
        'success' => false,
        'message' => 'Invalid JSON input: ' . json_last_error_msg()
    ]);
    exit;
}

    // Extract data
    $email = trim($data['email'] ?? '');
    $password = trim($data['password'] ?? '');

    // Validate inputs
    if (empty($email)) {
    echo json_encode(['success' => false, 'message' => 'Email is required']);
    exit;
    }
    
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        echo json_encode(['success' => false, 'message' => 'Invalid email address']);
        exit;
    }

    if (empty($password)) {
        echo json_encode(['success' => false, 'message' => 'Password is required']);
        exit;
    }

    // Hash the password (assuming the password is stored hashed in the database)
    $hashedPassword = md5($password);

    // Check user credentials
    try {
        $stmt = $pdo->prepare("SELECT * FROM users WHERE email = :email");
        $stmt->execute(['email' => $email]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($hashedPassword === $user['password'] && $email === $user['email']) {
             $_SESSION['unique_id'] = $user['unique_id']; // Store user ID in session
             $id =  $_SESSION['unique_id'];
            echo json_encode(['success' => true, 'message' => "Login successful, user Id = $id"]);
            
            
            //getting user device informations fo rlogin notifications
            $ipAddress = $_SERVER['REMOTE_ADDR'];
            $device = $_SERVER['HTTP_USER_AGENT'];
            $timestamp = date("Y-m-d H:i:s"); // Current date and time
            $subject = 'New Login Alert - Witty Nail';  
            $body = "<p>Hello,</p>  
                     <p>We detected a login attempt to your Witty Nail account.</p>  
                     <p><strong>Device:</strong> $device <br>  
                     <strong>IP Address:</strong> $ipAddress <br>  
                     <strong>Time:</strong> $timestamp</p>  
                     <p>If this was you, no further action is required. If you did not authorize this login, please reset your password immediately.</p>  
                     <p>Stay secure,<br><strong>Witty Nail Support Team</strong></p>";  


            $result = EmailService::sendEmail("$email", "$subject", "$body");
            echo $result;
            
        } else {
            echo json_encode(['success' => false, 'message' => 'Invalid email or password']);
        }
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Error checking credentials']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}
