<?php
session_start();
require 'mail.php'; // Include this file

$allowed_origins = [
    "http://localhost:3000",
    "https://nail-salon-gamma.vercel.app",
    "https://checkout.stripe.com",
    "https://wittynailtip.com"
];

if (isset($_SERVER['HTTP_ORIGIN']) && in_array($_SERVER['HTTP_ORIGIN'], $allowed_origins)) {
    header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
    header("Vary: Origin"); // Helps with caching issues
} else {
    header("Access-Control-Allow-Origin: *"); // Avoid using * in production
}

// CORS headers
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
} 


// Database connection
$host = 'localhost';
$dbname = 'lxiernde_witty';
$username = 'lxiernde_witty';
$pass = 'Wittynail2024.';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $GLOBALS['pdo'] = $pdo; // ✅ Make globally accessible
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed']);
    exit;
}


require_once 'stripe-php/init.php';

?>