<?php
require 'headers.php';
// Stripe API initialization
require_once 'stripe-php/init.php';// Ensure Stripe library is installed via Composer
$stripe = new \Stripe\StripeClient('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');


$unique_id = $_SESSION['unique_id']; // Get the user's unique ID from the session

try {
    // Fetch all favorite products for the user
    $stmt = $pdo->prepare("SELECT product_id, fav_id FROM fav WHERE unique_id = :unique_id");
    $stmt->execute(['unique_id' => $unique_id]);
    $favProducts = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$favProducts) {
        echo json_encode(['success' => true, 'data' => [], 'message' => 'No favorite products found']);
        exit;
    }

    $productData = [];
    

    // Loop through each favorite product and fetch details from Stripe
    foreach ($favProducts as $fav) {
        $product_id = $fav['product_id'];
         $fav_id = $fav['fav_id']; // Get the fav_id

        try {
            // Fetch the product from Stripe
            $product = $stripe->products->retrieve($product_id);

            // Fetch associated prices for each product
            $prices = $stripe->prices->all(['product' => $product->id]);

            // Add product and price details to the array
            $productData[] = [
                 'fav_id' => $fav_id, // Include fav_id in response
                'id' => $product->id,
                'name' => $product->name,
                'description' => $product->description,
                'images' => $product->images,
                'prices' => array_map(function ($price) {
                    return [
                        'id' => $price->id,
                        'unit_amount' => $price->unit_amount / 100, // Convert to dollars
                        'currency' => strtoupper($price->currency),
                    ];
                }, $prices->data),
            ];
        } catch (Exception $e) {
            // Handle Stripe API errors for individual products
            $productData[] = [
                'product_id' => $product_id,
                'error' => 'Product not found on Stripe',
            ];
        }
    }

    // Send JSON response with all the favorite product data
    echo json_encode([
        'success' => true,
        'data' => $productData,
    ]);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Error fetching favorite products']);
}
