<?php
require 'headers.php';



$unique_id = $_SESSION['unique_id']; // Get the unique ID from the session

// Retrieve POST data
$data = json_decode(file_get_contents('php://input'), true);
$fav_id = $data['fav_id'] ?? null;

// Validate fav_id
if (!$fav_id) {
    echo json_encode(['success' => false, 'message' => 'Favorite ID is required']);
    exit;
}

try {
    // Check if the product exists in the favorites for this user
    $stmt = $pdo->prepare("SELECT * FROM fav WHERE fav_id = :fav_id AND unique_id = :unique_id");
    $stmt->execute([':fav_id' => $fav_id, ':unique_id' => $unique_id]);
    $favItem = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$favItem) {
        echo json_encode(['success' => false, 'message' => 'Product not found in favorites']);
        exit;
    }

    // Delete the product from the favorites
    $stmt = $pdo->prepare("DELETE FROM fav WHERE fav_id = :fav_id AND unique_id = :unique_id");
    $stmt->execute([':fav_id' => $fav_id, ':unique_id' => $unique_id]);

    if ($stmt->rowCount() > 0) {
        echo json_encode(['success' => true, 'message' => 'This product has been removed from your favorites']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to remove product from favorites']);
    }
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Error removing product from favorites', 'error' => $e->getMessage()]);
}
