<?php
require 'headers.php';

/**
 * Adds a product to the favorites list.
 *
 * @param array $data The request data containing the product ID.
 * @return array The response message.
 */
function addToFavorites($data) {
    global $pdo;

 
    $unique_id = $_SESSION['unique_id'];

    // Ensure the product ID is provided
    if (!isset($data['product_id']) || empty($data['product_id'])) {
        return ['success' => false, 'message' => 'Product ID is required'];
    }

    // Generate a unique favorite ID
    $fav_id = rand(20000, 100000);
    $created = date('Y-m-d H:i:s');

    try {
        // Insert the item into the favorites table
        $stmt = $pdo->prepare("INSERT INTO fav (unique_id, product_id, fav_id, created) 
                               VALUES (:unique_id, :product_id, :fav_id, :created)");
        $stmt->execute([
            'unique_id' => $unique_id,
            'product_id' => $data['product_id'],
            'fav_id' => $fav_id,
            'created' => $created,
        ]);

        return ['success' => true, 'message' => 'Product added to favorites'];
    } catch (PDOException $e) {
        return ['success' => false, 'message' => 'Error adding to favorites'];
    }
}

// Fetch the request data
$data = json_decode(file_get_contents('php://input'), true);

// Execute the function and return the response
$response = addToFavorites($data);
echo json_encode($response);
?>
