<?php
session_start();
require 'headers.php';

/**
 * Adds a product to the cart with authentication and validation checks.
 *
 * @param array $data The request data containing product details.
 * @return array The response message.
 */
function addToCart($data) {
    global $pdo;



    $unique_id = $_SESSION['unique_id'];

    // Ensure all required fields are present
    if (!isset($data['product_id'], $data['quantity'], $data['color'], $data['size'])) {
        return ['success' => false, 'message' => 'All fields are required (product_id, quantity, color, size)'];
    }

    // Generate a unique cart ID
    $cart_id = rand(40000, 900000);

    try {
        // Insert the item into the cart table
        $stmt = $pdo->prepare("INSERT INTO cart (cart_id, unique_id, product_id, quantity, color, size, created) 
                               VALUES (:cart_id, :unique_id, :product_id, :quantity, :color, :size, :created)");
        $stmt->execute([
            'cart_id' => $cart_id,
            'unique_id' => $unique_id,
            'product_id' => $data['product_id'],
            'quantity' => $data['quantity'],
            'color' => $data['color'],
            'size' => $data['size'],
            'created' => date('Y-m-d H:i:s'),
        ]);

        return ['success' => true, 'message' => 'Product added to cart'];
    } catch (PDOException $e) {
        return ['success' => false, 'message' => 'Failed to add product to cart'];
    }
}

// Fetch the request data
$data = json_decode(file_get_contents('php://input'), true);

// Execute the function and return the response
$response = addToCart($data);
echo json_encode($response);
?>
