<?php
require 'headers.php';

$stripe = new \Stripe\StripeClient('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');

// DB connect
$conn = new mysqli('localhost', 'lxiernde_witty', 'Wittynail2024.', 'lxiernde_witty');
if ($conn->connect_error) {
    die(json_encode(['status' => 'error', 'message' => 'Database connection failed.']));
}

try {
    // Fetch all accessories from product table
    $query = "SELECT product_id, price, created_at, pimg2, pimg3, pimg4, pimg5 
              FROM product 
              WHERE category = 'accessory' 
              ORDER BY created_at DESC";

    $result = $conn->query($query);

    $productData = [];

    while ($row = $result->fetch_assoc()) {
        $productId = $row['product_id'];

        // Get Stripe product & price details
        $product = $stripe->products->retrieve($productId);
        $prices = $stripe->prices->all(['product' => $productId]);
        $price = $prices->data[0] ?? null;

        // Collect accessory image URLs from DB (excluding Stripe image)
        $images = [];
        for ($i = 2; $i <= 5; $i++) {
            $imgKey = "pimg$i";
            if (!empty($row[$imgKey])) {
                $images[] = $row[$imgKey];
            }
        }

        $productData[] = [
            'id' => $productId,
            'name' => $product->name,
            'description' => $product->description,
            'images' => $images,
            'price' => $price ? [
                'id' => $price->id,
                'unit_amount' => $price->unit_amount / 100,
                'currency' => strtoupper($price->currency)
            ] : null,
            'created_at' => $row['created_at']
        ];
    }

    $conn->close();

    echo json_encode([
        'status' => 'success',
        'data' => $productData
    ]);

} catch (\Stripe\Exception\ApiErrorException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Stripe error: ' . $e->getMessage()]);
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => 'Error: ' . $e->getMessage()]);
}
?>
